<?php

defined('PF_VERSION') OR exit('Access denied');

class Pf_Post_Shortcode extends Pf_Base_Post_Shortcode
{

    private $settings = array();

    public function __construct($attrs = array(), $content = '')
    {
        parent::__construct($attrs, $content);
        $this->get_setting();
        $this->model->clean();
        $this->base_select(null, true);
    }

    /**
     * Display post detail
     */
    public function post_main()
    {
        $post_id = array_map('convent_to_number', $this->get_value_attr('id'));
        $result = array(
            'data' => null
        );
        $show_comment = '';
        $show_rating = '';
        if (isset($post_id[0]) && $post_id[0] > 0) {
            $item = $this->base_select->select($this->select_columns)->conditions('where pf_posts.id = ?')
                            ->param($post_id)->get(3);
            if (!empty($item)) {
                $this->views($post_id, $item->post_views);
                $comment = $this->settings['comment'] == 1 && $this->settings['enable_comment'] == 1 ? $this->get_comments($post_id) : '';
                $tag = $this->get_tag_post($post_id, $this->settings['page_lists']);
                $item->tags = isset($tag[$item->id]) ? implode(' ', $tag[$item->id]) : '';
                $item->comments = isset($comment[$item->id]) ? $comment[$item->id] : '';
                $item->link_detail = '';
                $show_comment = $this->settings['comment'] == 1 && $this->settings['enable_comment'] == 1 ? Pf::shortcode()->exec('{pf:comment key=post_' . $post_id[0] . '}') : '';
                $show_rating = $this->settings['enable_rating'] == 1 && get_configuration('enable', 'pf_rating') == 1 ? Pf::shortcode()->exec('{pf:rating key=post_' . $post_id[0] . '}') : '';
            }
            $result = array(
                'data' => array($item)
            );
        }
        return $this->view->render('post', array('posts' => $this->get_content($result, 'post_detail') . $show_rating . $show_comment));
    }

    private function get_setting()
    {
        $this->setting->set_name('pf_comment');
        $this->settings['comment'] = $this->setting->get_value('enable');
        $this->setting->set_name('pf_post');
        $this->settings['page_lists'] = $this->setting->get_value('page_lists');
        $this->settings['enable_comment'] = $this->setting->get_value('enable_comment');
        $this->settings['enable_rating'] = $this->setting->get_value('enable_rating');
    }

    private function views($post_id, $views)
    {
        $this->model->table('pf_posts')->conditions('id = ?')
                ->param($post_id)
                ->update(array('post_views' => $views + 1), false);
    }

}
